<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Site\View\Myprofile;

defined('_JEXEC') or die;

use Exception;
use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;
use Solidres\HTML\Jquery;
use Solidres\MVC\View\HtmlView as SolidresHtmlView;
use Solidres\Version;

class HtmlView extends SolidresHtmlView
{
    protected $state;
    protected $form;
    protected $returnPage;
    protected $id;
    protected $config;

    public function display($tpl = null)
    {
        $app  = Factory::getApplication();
        $user = $app->getIdentity();

        if ($user->guest) {
            $return = Uri::getInstance()->toString();
            $app->redirect(Route::_('index.php?option=com_users&view=login&return=' . base64_encode($return), false));

            return false;
        }

        $this->state      = $this->get('State');
        $this->form       = $this->getForm('Form');
        $this->returnPage = $this->getModel()->getReturnPage();
        $this->id         = $this->form->getValue('id');

        $this->getDocument()->getWebAssetManager()->addInlineScript(
            "
			Solidres.jQuery(function($) {
				$('.country_select').change(function() {
					$.ajax({
						url : 'index.php?option=com_solidres&format=json&task=states' + Solidres.context + '.find&id=' + $(this).val(),
						success : function(html) {
							$('.state_select').empty().html(html);
						}
					});
				});
			});
		"
        );

        if (count($errors = $this->get('Errors'))) {
            throw new Exception(implode(PHP_EOL, $errors), 500);
        }

        $this->config            = ComponentHelper::getParams('com_solidres');
        $this->showPoweredByLink = $this->config->get('show_solidres_copyright', '1');
        $customerUserGroups      = $this->config->get('customer_user_groups', []);
        $userGroups              = $user->getAuthorisedGroups();
        $access                  = false;

        foreach ($customerUserGroups as $customerUserGroup) {
            if (in_array($customerUserGroup, $userGroups)) {
                $access = true;
                break;
            }
        }

        if (!$access) {
            $app->enqueueMessage(Text::_('JERROR_ALERTNOAUTHOR'), 'error');
            $app->setHeader('status', 403, true);

            return false;
        }

        $options = ['relative' => true, 'version' => Version::getHashVersion()];
        HTMLHelper::_('stylesheet', 'com_solidres/assets/main.min.css', $options);
        HTMLHelper::_('stylesheet', 'plg_solidres_hub/assets/hub.min.css', $options);
        \Solidres\HTML\HTMLHelper::_('jquery.datepicker');

        $this->addToolbar();

        parent::display($tpl);
    }

    protected function addToolbar()
    {
        \Solidres\HTML\HTMLHelper::_('jquery.validate_locale');
        ToolbarHelper::apply('myprofile.apply', 'JToolbar_Apply');
        ToolbarHelper::cancel('myprofile.cancel', 'JToolbar_Close');
    }
}
