<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Module\SolidresCurrency\Site\Dispatcher;

defined('_JEXEC') or die;

use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\HTML\HTMLHelper;
use Solidres\MVC\FactoryTrait;
use Solidres\Version;

class Dispatcher extends AbstractModuleDispatcher
{
    use FactoryTrait;

    protected function getLayoutData(): array
    {
        HTMLHelper::_(
            'stylesheet',
            'com_solidres/assets/main.min.css',
            ['version' => Version::getHashVersion(), 'relative' => true]
        );
        $data          = parent::getLayoutData();
        $app           = $this->getApplication();
        $currencyModel = $this->createModel('Currencies');
        $currencyModel->setState('list.start', 0);
        $currencyModel->setState('list.limit', 0);
        $currencyModel->setState('filter.state', 1);
        $currencyModel->setState('list.ordering', 'u.currency_name');
        $data['currencyList']     = $currencyModel->getItems();
        $data['activeCurrencyId'] = $app->getUserState('current_currency_id', '');
        $data['showCodeSymbol']   = $data['params']->get('show_code_symbol', 0);

        return $data;
    }
}