<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @copyright Copyright (C) 2013 - 2021 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

namespace Joomla\Plugin\SolidresPayment\PayLater\Extension;

use Joomla\Event\SubscriberInterface;
use Solidres\Event\ReservationCheckConfirmedEvent;
use Solidres\Plugin\PaymentPlugin;
use Solidres\Plugin\PaymentPluginAware;

defined('_JEXEC') or die;

class PayLater extends PaymentPlugin implements SubscriberInterface
{
    use PaymentPluginAware;

    public function onReservationCheckConfirmed(ReservationCheckConfirmedEvent $event)
    {
        if ($event->getReservation()->payment_method_id === 'paylater') {
            $event->setIsConfirmed(true);
        }
    }
}
