<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Module\SolidresSummary\Site\Dispatcher;

defined('_JEXEC') or die;

use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;

class Dispatcher extends AbstractModuleDispatcher
{
    protected function getLayoutData()
    {
        $data = parent::getLayoutData();
        $app  = $this->getApplication();
        $app->getLanguage()->load('com_solidres', JPATH_ROOT . '/components/com_solidres');
        $context            = 'com_solidres.reservation.process';
        $reservationDetails = $app->getUserState($context, null);
        $data['view']       = $app->input->get('view');
        $data['layout']     = $app->input->get('layout');
        $data['option']     = $app->input->get('option');
        $data['task']       = $app->input->get('task');

        if (isset($reservationDetails)
            && isset($reservationDetails->checkin)
            && isset($reservationDetails->checkout)
            && ($data['option'] == 'com_solidres'
                && ($data['view'] == 'reservationasset' || ($data['view'] == 'apartment' && $data['layout'] == 'book') || $data['task'] == 'progress')
            )
        ) {
            $data['checkin']  = $reservationDetails->checkin;
            $data['checkout'] = $reservationDetails->checkout;

            if (empty($data['checkin']) || empty($data['checkout'])) {
                return false;
            }
        }

        return $data;
    }
}