<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Api\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Database\DatabaseInterface;
use Joomla\Database\ParameterType;
use Solidres\MVC\Controller\ApiControllerAccessAbstract;

class ExtrasController extends ApiControllerAccessAbstract
{
    protected $contentType = 'extras';

    protected array $filtersList = ['reservation_asset_id' => 'UINT', 'access' => 'ARRAY'];


    public function getPropertyId(int $extraId): int
    {
        $db    = Factory::getContainer()->get(DatabaseInterface::class);
        $query = $db->getQuery(true)
            ->select($db->quoteName('reservation_asset_id'))
            ->from($db->quoteName('#__sr_extras'))
            ->where($db->quoteName('id') . ' = :id')
            ->bind(':id', $extraId, ParameterType::INTEGER);

        return (int)$db->setQuery($query)->loadResult();
    }
}
