<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Api\Controller;

defined('_JEXEC') or die;

use Solidres\MVC\Controller\ApiController;

class PaymenthistoryController extends ApiController
{
    protected $contentType = 'paymenthistory';

    protected array $filtersList = [
        'payment_date'      => 'USER_UTC',
        'payment_status'    => 'INT',
        'payment_method_id' => 'STRING',
        'reservation_id'    => 'UINT',
        'scope'             => 'UINT',
        'payment_type'      => 'STRING',
    ];

    public function getModel($name = 'Paymenthistory', $prefix = 'Administrator', $config = [])
    {
        $config = array_merge($config, ['ignore_request' => true, 'state' => $this->modelState]);

        return parent::getModel($name, $prefix, $config);
    }
}
