<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Api\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Access\Exception\NotAllowed;
use Joomla\CMS\Filter\InputFilter;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\ApiController;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Component\Solidres\Administrator\Model\ReservationassetModel;
use RuntimeException;
use Solidres\Utility\Utility;

class PropertiesController extends ApiController
{
    protected $contentType = 'reservationassets';
    protected $default_view = 'properties';

    public function displayList()
    {
        $apiFilterInfo = $this->input->get('filter', [], 'array');
        $filter        = InputFilter::getInstance();

        if (array_key_exists('author', $apiFilterInfo)) {
            $this->modelState->set('filter.author_id', $filter->clean($apiFilterInfo['author'], 'INT'));
        }

        if (array_key_exists('category', $apiFilterInfo)) {
            $this->modelState->set('filter.category_id', $filter->clean($apiFilterInfo['category'], 'INT'));
        }

        if (array_key_exists('search', $apiFilterInfo)) {
            $this->modelState->set('filter.search', $filter->clean($apiFilterInfo['search'], 'STRING'));
        }

        $user = $this->app->getIdentity();

        if ($user->authorise('core.manage', 'com_solidres') && array_key_exists('state', $apiFilterInfo)) {
            $this->modelState->set('filter.published', $filter->clean($apiFilterInfo['state'], 'INT'));
        } elseif (PluginHelper::isEnabled('solidres', 'hub') && ($partnerId = Utility::getPartnerId())) {
            $this->modelState->set('filter.partner_id', $partnerId);
        } else {
            $this->modelState->set('filter.published', 1);
        }

        if (array_key_exists('tag', $apiFilterInfo)) {
            $this->modelState->set('filter.tag', $filter->clean($apiFilterInfo['tag'], 'INT'));
        }

        $apiListInfo = $this->input->get('list', [], 'array');

        if (array_key_exists('ordering', $apiListInfo)) {
            $this->modelState->set('list.ordering', $filter->clean($apiListInfo['ordering'], 'STRING'));
        }

        if (array_key_exists('direction', $apiListInfo)) {
            $this->modelState->set('list.direction', $filter->clean($apiListInfo['direction'], 'STRING'));
        }

        return parent::displayList();
    }

    public function displayItem($id = null)
    {
        $user = $this->app->getIdentity();

        if ($item = parent::displayItem($id)) {
            $canManage = $user->authorise('core.manage', 'com_solidres') || (PluginHelper::isEnabled(
                        'solidres',
                        'hub'
                    ) && in_array($item->partner_id, Utility::getPartnerIds()));

            if (!$canManage && (int)$item->state !== 1) {
                throw new NotAllowed();
            }
        }

        return $item;
    }

    protected function allowEdit($data = [], $key = 'id')
    {
        if (!($canEdit = parent::allowEdit($data, $key))
            && PluginHelper::isEnabled('solidres', 'hub')
            && Utility::isAssetPartner($this->app->getIdentity()->id, $data[$key])
        ) {
            $canEdit = true;
        }

        return $canEdit;
    }

    protected function allowAdd($data = [], $key = 'id')
    {
        if (!($canAdd = parent::allowAdd($data))
            && PluginHelper::isEnabled('solidres', 'hub')
            && Utility::getPartnerId()
        ) {
            $canAdd = true;
        }

        return $canAdd;
    }

    public function delete($id = null)
    {
        if ($id === null) {
            $id = $this->input->get('id', 0, 'int');
        }

        $user = $this->app->getIdentity();

        if (!$user->authorise('core.delete', 'com_solidres')
            && (!PluginHelper::isEnabled('solidres', 'hub') || !Utility::isAssetPartner($user->id, $id))
        ) {
            throw new NotAllowed('JLIB_APPLICATION_ERROR_DELETE_NOT_PERMITTED', 403);
        }

        /** @var ReservationassetModel $model */
        $model = $this->getModel('Reservationasset', 'Administrator', ['ignore_request' => true]);

        if (!$model) {
            throw new RuntimeException(Text::_('JLIB_APPLICATION_ERROR_MODEL_CREATE'));
        }

        // Remove the item.
        if (!$model->delete($id)) {
            if ($model->getError() !== false) {
                throw new RuntimeException($model->getError(), 500);
            }

            throw new RuntimeException(Text::_('JLIB_APPLICATION_ERROR_DELETE'), 500);
        }

        $this->app->setHeader('status', 204);
    }
}
