<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Api\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Component\Solidres\Administrator\Model\RoomtypeModel;
use Joomla\Database\DatabaseInterface;
use Joomla\Database\ParameterType;
use Solidres\MVC\Controller\ApiControllerAccessAbstract;

class RoomtypesController extends ApiControllerAccessAbstract
{
    protected $contentType = 'roomtypes';

    protected array $filtersList = ['reservation_asset_id' => 'UINT'];

    protected function preprocessSaveData(array $data): array
    {
        if ($this->app->getInput()->getMethod() === 'PATCH' && !isset($data['default_tariff'])) {
            /**
             * @var RoomtypeModel $model
             */
            $model                  = $this->getModel('roomtype');
            $roomType               = $model->getItem($data['id']);
            $data['default_tariff'] = [];

            if (empty($roomType->default_tariff)) {
                for ($i = 0; $i < 7; $i++) {
                    $data['default_tariff'][0][0][$i] = 0;
                }
            } else {
                foreach ($roomType->default_tariff->details as $detail) {
                    $data['default_tariff'][$roomType->default_tariff->id][$detail->id][$detail->w_day] = $detail->price;
                }
            }
        }

        return $data;
    }

    public function getPropertyId(int $roomTypeId): int
    {
        $db    = Factory::getContainer()->get(DatabaseInterface::class);
        $query = $db->getQuery(true)
            ->select($db->quoteName('reservation_asset_id'))
            ->from($db->quoteName('#__sr_roomtypes'))
            ->where($db->quoteName('id') . ' = :id')
            ->bind(':id', $roomTypeId, ParameterType::INTEGER);

        return (int)$db->setQuery($query)->loadResult();
    }
}
