<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Api\Serializer;

defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;
use Joomla\CMS\Serializer\JoomlaSerializer;
use Joomla\CMS\Tag\TagApiSerializerTrait;
use Joomla\CMS\Uri\Uri;
use Tobscure\JsonApi\Relationship;
use Tobscure\JsonApi\Resource;

class SolidresSerializer extends JoomlaSerializer
{
    use TagApiSerializerTrait;

    public function property($model): Relationship
    {
        $serializer = new JoomlaSerializer('properties');
        $resource   = (new Resource($model->reservation_asset_id, $serializer))
            ->addLink(
                'self',
                Route::link(
                    'site',
                    Uri::root() . 'api/index.php/v1/solidres/properties/' . $model->reservation_asset_id
                )
            );

        return new Relationship($resource);
    }

    public function category($model): Relationship
    {
        $serializer = new JoomlaSerializer('categories');
        $resource   = (new Resource($model->category_id, $serializer))
            ->addLink(
                'self',
                Route::link('site', Uri::root() . 'api/index.php/v1/solidres/categories/' . $model->category_id)
            );

        return new Relationship($resource);
    }

    public function createdBy($model): Relationship
    {
        $serializer = new JoomlaSerializer('users');

        $resource = (new Resource($model->created_by, $serializer))
            ->addLink('self', Route::link('site', Uri::root() . 'api/index.php/v1/users/' . $model->created_by));

        return new Relationship($resource);
    }

    public function partnerId($model): Relationship
    {
        $serializer = new JoomlaSerializer('customers');
        $resource   = (new Resource($model->partner_id, $serializer))
            ->addLink('self', Route::link('site', Uri::root() . 'api/index.php/v1/customers/' . $model->partner_id));

        return new Relationship($resource);
    }

    public function currencyId($model): Relationship
    {
        $serializer = new JoomlaSerializer('currencies');
        $resource   = (new Resource($model->currency_id, $serializer))
            ->addLink('self', Route::link('site', Uri::root() . 'api/index.php/v1/currencies/' . $model->currency_id));

        return new Relationship($resource);
    }

    public function countryId($model): Relationship
    {
        $serializer = new JoomlaSerializer('countries');
        $resource   = (new Resource($model->country_id, $serializer))
            ->addLink('self', Route::link('site', Uri::root() . 'api/index.php/v1/countries/' . $model->country_id));

        return new Relationship($resource);
    }

    public function taxId($model): Relationship
    {
        $serializer = new JoomlaSerializer('taxes');
        $resource   = (new Resource($model->tax_id, $serializer))
            ->addLink(
                'self',
                Route::link('site', Uri::root() . 'api/index.php/v1/solidres/taxes/' . $model->tax_id)
            );

        return new Relationship($resource);
    }

    public function reservationId($model): Relationship
    {
        $serializer = new JoomlaSerializer('reservations');
        $resource   = (new Resource($model->reservation_id, $serializer))
            ->addLink(
                'self',
                Route::link('site', Uri::root() . 'api/index.php/v1/solidres/reservations/' . $model->reservation_id)
            );

        return new Relationship($resource);
    }

    public function experienceId($model): Relationship
    {
        $serializer = new JoomlaSerializer('experiences');
        $resource   = (new Resource($model->experience_id, $serializer))
            ->addLink(
                'self',
                Route::link('site', Uri::root() . 'api/index.php/v1/solidres/experiences/' . $model->experience_id)
            );

        return new Relationship($resource);
    }

    public function originId($model): Relationship
    {
        $serializer = new JoomlaSerializer('origins');
        $resource   = (new Resource($model->origin_id, $serializer))
            ->addLink(
                'self',
                Route::link('site', Uri::root() . 'api/index.php/v1/solidres/origins/' . $model->origin_id)
            );

        return new Relationship($resource);
    }

    public function couponId($model): Relationship
    {
        $serializer = new JoomlaSerializer('coupons');
        $resource   = (new Resource($model->coupon_id, $serializer))
            ->addLink(
                'self',
                Route::link('site', Uri::root() . 'api/index.php/v1/solidres/coupons/' . $model->coupon_id)
            );

        return new Relationship($resource);
    }
}