<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Api\View\Coupons;

defined('_JEXEC') or die;

use Solidres\Media\ImageUploaderHelper;
use Solidres\Media\Path;
use Solidres\MVC\View\JsonApiView as BaseApiView;

class JsonapiView extends BaseApiView
{
    protected $fieldsToRenderList = [
        'id',
        'coupon_name',
        'coupon_code',
        'amount',
        'reservation_asset_id',
        'is_percent',
        'valid_from',
        'valid_to',
        'valid_from_checkin',
        'valid_to_checkin',
        'customer_group_id',
        'state',
        'quantity',
        'params',
    ];

    protected function prepareItem($item)
    {
        if (($item = parent::prepareItem($item)) && !empty($item->params['image'])) {
            $item->params['image'] = ImageUploaderHelper::getImage(
                Path::PROPERTY_COUPON . '/' . $item->id . '/' . $item->params['image']
            );
        }

        return $item;
    }
}
