<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Api\View\Extras;

defined('_JEXEC') or die;

use Solidres\Media\ImageUploaderHelper;
use Solidres\Media\Path;
use Solidres\MVC\View\JsonApiView as BaseApiView;

class JsonapiView extends BaseApiView
{
    protected $fieldsToRenderList = [
        'id',
        'name',
        'charge_type',
        'max_quantity',
        'daily_chargable',
        'price',
        'price_adult',
        'price_child',
        'reservation_asset_id',
        'state',
        'access',
        'price_includes_tax',
        'description',
        'tax_id',
        'params',
        'property',
    ];

    protected $relationship = [
        'tax_id',
        'property',
    ];

    protected function prepareItem($item)
    {
        if (($item = parent::prepareItem($item)) && !empty($item->params['image'])) {
            $item->params['image'] = ImageUploaderHelper::getImage(
                Path::PROPERTY_COUPON . '/' . $item->id . '/' . $item->params['image']
            );
        }

        return $item;
    }
}
