<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Api\View\Properties;

defined('_JEXEC') or die;

use Joomla\CMS\Helper\TagsHelper;
use Solidres\MVC\View\JsonApiView as BaseApiView;
use Solidres\Media\ImageUploaderHelper;
use Solidres\Media\Type;

class JsonapiView extends BaseApiView
{
    protected $fieldsToRenderList = [
        'id',
        'asset_id',
        'name',
        'alternative_name',
        'alias',
        'address_1',
        'address_2',
        'city',
        'postcode',
        'phone',
        'description',
        'email',
        'website',
        'featured',
        'fax',
        'rating',
        'geo_state_id',
        'country_id',
        'created_date',
        'modified_date',
        'created_by',
        'modified_by',
        'state',
        'checked_out',
        'checked_out_time',
        'ordering',
        'archived',
        'approved',
        'access',
        'params',
        'language',
        'hits',
        'metatitle',
        'metakey',
        'metadesc',
        'metadata',
        'partner_id',
        'lat',
        'lng',
        'default',
        'deposit_required',
        'deposit_is_percentage',
        'deposit_amount',
        'deposit_by_stay_length',
        'deposit_include_extra_cost',
        'currency_id',
        'tax_id',
        'booking_type',
        'price_includes_tax',
        'distance_from_city_centre',
        'tab_content',
        'parent_category_title',
        'parent_category_id',
        'parent_category_uid',
        'parent_category_level',
        'number_of_roomtype',
        'country_name',
        'geostate_name',
        'tags',
        'category',
        'media',
    ];

    protected $fieldsToRenderItem = [];

    protected $relationship = [
        'category',
        'tags',
        'created_by',
        'partner_id',
        'currency_id',
        'country_id',
    ];

    protected function prepareItem($item)
    {
        if (!$item) {
            return $item;
        }

        if (!empty($item->tags->tags)) {
            $tagsIds    = explode(',', $item->tags->tags);
            $item->tags = $item->tagsHelper->getTags($tagsIds);
        } else {
            $item->tags = [];
            $tags       = new TagsHelper();
            $tagsIds    = $tags->getTagIds($item->id, 'com_solidres.property');

            if (!empty($tagsIds)) {
                $tagsIds    = explode(',', $tagsIds);
                $item->tags = $tags->getTags($tagsIds);
            }
        }

        if (!is_array($item->media)) {
            $item->media = ImageUploaderHelper::getData($item->id, Type::PROPERTY);
        }

        foreach ($item->media as &$image) {
            $image = ImageUploaderHelper::getImageThumb($image, ImageUploaderHelper::getThumbByType(Type::PROPERTY));
        }

        return parent::prepareItem($item);
    }
}
