<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Api\View\Reservations;

defined('_JEXEC') or die;

use Solidres\MVC\View\JsonApiView as BaseApiView;

class JsonapiView extends BaseApiView
{
    protected array $jsonFields = ['reservation_meta'];

    protected $fieldsToRenderList = [
        'id',
        'state',
        'customer_id',
        'created_date',
        'modified_date',
        'modified_by',
        'created_by',
        'checked_out',
        'checked_out_time',
        'payment_method_id',
        'payment_method_txn_id',
        'payment_method_surcharge',
        'payment_method_discount',
        'payment_status',
        'payment_data',
        'code',
        'coupon_id',
        'coupon_code',
        'customer_title',
        'customer_firstname',
        'customer_middlename',
        'customer_lastname',
        'customer_email',
        'customer_phonenumber',
        'customer_mobilephone',
        'customer_company',
        'customer_address1',
        'customer_address2',
        'customer_city',
        'customer_zipcode',
        'customer_country_id',
        'customer_geo_state_id',
        'customer_vat_number',
        'customer_ip',
        'customer_coordinates',
        'customer_language',
        'customer_ua',
        'customer_ismobile',
        'checkin',
        'checkout',
        'currency_id',
        'currency_code',
        'total_price',
        'total_price_tax_incl',
        'total_price_tax_excl',
        'total_extra_price',
        'total_extra_price_tax_incl',
        'total_extra_price_tax_excl',
        'total_discount',
        'note',
        'reservation_asset_id',
        'reservation_asset_name',
        'deposit_amount',
        'total_paid',
        'discount_pre_tax',
        'tax_amount',
        'tourist_tax_amount',
        'booking_type',
        'total_single_supplement',
        'total_fee',
        'token',
        'origin',
        'origin_id',
        'accessed_date',
        'target',
        'cm_provider',
        'cm_id',
        'cm_creation_date',
        'cm_modification_date',
        'cm_channel_order_id',
        'cm_payment_collect',
        'is_approved',
        'checkinout_status',
        'checked_in_date',
        'checked_out_date',
        'reservation_meta',
        'confirmation_date',
        'customer_fullname',
        'total_amount',
        'length_of_stay',
        'customer_country_name',
        'property',
    ];

    protected $relationship = [
        'property',
        'customer_id',
        'created_by',
        'coupon_id',
        'currency_id',
        'origin_id',
    ];
}
