<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Api\View\Roomtypes;

defined('_JEXEC') or die;

use Solidres\MVC\View\JsonApiView as BaseApiView;
use Solidres\Media\ImageUploaderHelper;
use Solidres\Media\Type;

class JsonapiView extends BaseApiView
{
    protected $fieldsToRenderList = [
        'id',
        'reservation_asset_id',
        'name',
        'alias',
        'description',
        'state',
        'checked_out',
        'checked_out_time',
        'created_by',
        'created_date',
        'modified_by',
        'modified_date',
        'language',
        'params',
        'featured',
        'ordering',
        'occupancy_max',
        'occupancy_adult',
        'occupancy_child',
        'occupancy_child_age_range',
        'smoking',
        'is_private',
        'is_master',
        'number_of_room',
        'property',
        'media',
    ];

    protected $fieldsToRenderItem = [];

    protected $relationship = [
        'created_by',
        'property',
    ];

    protected function prepareItem($item)
    {
        if (!$item) {
            return $item;
        }

        if (!isset($item->media) || !is_array($item->media)) {
            $item->media = ImageUploaderHelper::getData($item->id, Type::ROOM_TYPE);
        }

        foreach ($item->media as &$image) {
            $image = ImageUploaderHelper::getImageThumb($image, ImageUploaderHelper::getThumbByType(Type::PROPERTY));
        }

        return parent::prepareItem($item);
    }
}
