<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\WebAsset\WebAssetManager;
use Joomla\Input\Input;
use Solidres\MVC\FactoryTrait;
use Solidres\Version;

class DisplayController extends BaseController
{
    use FactoryTrait;

    protected $default_view = 'reservationassets';

    public function __construct(
        $config = [],
        MVCFactoryInterface $factory = null,
        ?CMSApplicationInterface $app = null,
        ?Input $input = null
    ) {
        parent::__construct($config, $factory, $app, $input);
        $params = ComponentHelper::getParams('com_solidres');
        $expOnly = PluginHelper::isEnabled('solidres', 'experience') && $params->get('main_activity', '') == '1';

        if ($defaultView = trim($params->get('default_view', ''))) {
            $this->default_view = $defaultView;
        } elseif ($expOnly) {
            $this->default_view = 'expdashboard';
        } elseif (PluginHelper::isEnabled('solidres', 'statistics')) {
            $this->default_view = 'statistics';
        }

        if (!$this->app->input->get('view')) {
            $this->app->input->set('view', $this->default_view);
        }
    }

    public function display($cachable = false, $urlparams = [])
    {
        /** @var WebAssetManager $wa */
        $wa = $this->app->getDocument()->getWebAssetManager();
        $wa->useScript('com_solidres.jquery-ui')->useStyle('com_solidres.jquery-ui');
        $wa->useScript('com_solidres.admin')
            ->useScript('com_solidres.common')
            ->useScript('com_solidres.jquery-validate');

        HTMLHelper::_(
            'stylesheet',
            'com_solidres/assets/main.min.css',
            ['version' => Version::getHashVersion(), 'relative' => true]
        );

        // B/C
        $view = $this->app->input->get('view');

        foreach (['statistics' => 'statistics', 'experience' => 'expdashboard'] as $pluginLegacy => $viewLegacy) {
            if ($view === $viewLegacy && !is_file(
                    JPATH_PLUGINS . '/solidres/' . $pluginLegacy . '/src/Extension/Statistics.php'
                )) {
                return $this->getPluginLegacyController($viewLegacy)->display($cachable, $urlparams);
            }
        }

        return parent::display($cachable, $urlparams);
    }
}
