<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Controller;

use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Factory;
use Joomla\Utilities\ArrayHelper;

defined('_JEXEC') or die;

class ReservationassetController extends FormController
{
    protected function allowAdd($data = [])
    {
        // Initialise variables.
        $user       = Factory::getApplication()->getIdentity();
        $categoryId = ArrayHelper::getValue($data, 'category_id', $this->input->getUint('filter_category_id'), 'int');
        $allow      = null;

        if ($categoryId) {
            // If the category has been passed in the data or URL check it.
            $allow = $user->authorise('core.create', 'com_solidres.category.' . $categoryId);
        }

        if ($allow === null) {
            // In the absense of better information, revert to the component permissions.
            return parent::allowAdd($data);
        } else {
            return $allow;
        }
    }
}
