<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Controller;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\Component\Solidres\Administrator\Helper\SolidresHelper;
use Joomla\Database\DatabaseInterface;
use Solidres\RoomType\RoomType;
use Solidres\Utility\Utility;

defined('_JEXEC') or die;

class RoomtypesController extends AdminController
{
    public function getModel($name = 'Roomtype', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    private function isAuthorized($roomTypeId)
    {
        if (Factory::getApplication()->isClient('administrator')) {
            return true;
        } else {
            $roomTypeTable = $this->factory->createTable('RoomType', 'Administrator');

            if (!$roomTypeTable->load($roomTypeId)) {
                return false;
            }

            $joomlaUserId      = $this->app->getIdentity()->id;
            $isPropertyPartner = Utility::isAssetPartner($joomlaUserId, $roomTypeTable->reservation_asset_id);

            if (!$isPropertyPartner) {
                return false;
            }

            return true;
        }
    }

    public function checkRoomReservation()
    {
        $roomId    = $this->input->get('id', 0, 'int');
        $roomTable = $this->factory->createTable('Room', 'Administrator');

        if (!$roomTable->load($roomId)) {
            echo json_encode([]);

            $this->app->close();
        }

        if (!$this->isAuthorized($roomTable->room_type_id)) {
            echo json_encode([]);

            $this->app->close();
        }

        echo json_encode((new RoomType())->canDeleteRoom($roomId));

        $this->app->close();
    }

    public function findRoom()
    {
        $roomTypeId = $this->input->get('id', 0, 'int');

        if (!$this->isAuthorized($roomTypeId)) {
            echo json_encode([]);

            $this->app->close();
        }

        $result = (new RoomType())->getListRooms($roomTypeId);
        $i      = 0;
        $json   = [];

        if (!empty($result)) {
            foreach ($result as $rs) {
                $json[$i]['id']   = $rs->id;
                $json[$i]['name'] = $rs->label;
                $i++;
            }
        }

        echo json_encode($json);
        $this->app->close();
    }

    public function removeRoomPermanently()
    {
        $roomId = $this->input->get('id', 0, 'int');
        $result = false;

        if ($roomId > 0) {
            $roomModel = $this->factory->createModel('Room', 'Administrator', ['ignore_request' => true]);
            $room      = $roomModel->getItem($roomId);

            if (!$this->isAuthorized($room->room_type_id)) {
                echo json_encode([]);

                $this->app->close();
            }

            $result = $roomModel->delete($roomId);
        }

        echo json_encode($result);

        $this->app->close();
    }

    public function getSingle()
    {
        $roomTypeId = $this->input->get('id', 0, 'int');

        if ($roomTypeId > 0) {
            if (!$this->isAuthorized($roomTypeId)) {
                echo json_encode([]);

                $this->app->close();
            }

            $dbo   = Factory::getContainer()->get(DatabaseInterface::class);
            $query = $dbo->getQuery(true);
            $query->select('*')->from('#__sr_room_types')->where('id = ' . $roomTypeId);
            echo json_encode($dbo->setQuery($query)->loadObject());
        }

        $this->app->close();
    }

    public function find()
    {
        $reservationAssetId = $this->input->get('id', 0, 'int');
        $output             = $this->input->get('output', 'html', 'string');
        $roomTypes          = SolidresHelper::getRoomTypeOptions($reservationAssetId, $output);
        if ($output == 'html') {
            $html = '';
            foreach ($roomTypes as $roomType) {
                $html .= '<option value="' . $roomType->value . '">' . $roomType->text . '</option>';
            }
            echo $html;
        } else {
            $results = [];
            foreach ($roomTypes as $roomType) {
                $results[] = ['id' => $roomType->id, 'name' => $roomType->name];
            }
            echo json_encode($results);
        }

        $this->app->close();
    }
}
