<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\Component\Solidres\Administrator\Helper\SolidresHelper;

/**
 * State list controller class.
 *
 * @package       Solidres
 * @subpackage    State
 * @since         0.1.0
 */
class StatesJsonController extends AdminController
{
    public function getModel($name = 'States', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    public function find()
    {
        $countryId = $this->input->get('id', 0, 'int');
        $states    = SolidresHelper::getGeoStateOptions($countryId);
        $html      = '';
        foreach ($states as $state) {
            $html .= '<option value="' . $state->value . '">' . $state->text . '</option>';
        }
        echo $html;
        $this->app->close();
    }
}
