<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Dispatcher;

defined('_JEXEC') or die;

use Joomla\CMS\Access\Exception\NotAllowed;
use Joomla\CMS\Dispatcher\ComponentDispatcher;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Plugin\PluginHelper;
use Solidres\Event\SolidresAuthenticationEvent;
use Solidres\MVC\FactoryTrait;

class Dispatcher extends ComponentDispatcher
{
    use FactoryTrait;

    protected function checkAccess()
    {
        parent::checkAccess();

        if (PluginHelper::isEnabled('solidres', 'acl')) {

            if (in_array(false, SolidresAuthenticationEvent::dispatch()->getResult(), true)) {
                throw new NotAllowed(Text::_('JERROR_ALERTNOAUTHOR'), 403);
            }
        }
    }

    public function getController(string $name, string $client = '', array $config = []): BaseController
    {
        return $this->getPluginLegacyController($name, $client, $config) ?: parent::getController(
            $name,
            $client,
            $config
        );
    }
}
