<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;

class ChargetypeField extends ListField
{
    protected $type = 'ChargeType';

    public function getOptions()
    {
        $options = [];

        $disabled = !PluginHelper::isEnabled('solidres', 'advancedextra');

        $options[] = HTMLHelper::_(
            'select.option',
            0,
            Text::_('SR_FIELD_EXTRA_CHARGE_TYPE_PER_ROOM'),
            'value',
            'text',
            false
        );
        $options[] = HTMLHelper::_(
            'select.option',
            1,
            Text::_('SR_FIELD_EXTRA_CHARGE_TYPE_PER_BOOKING'),
            'value',
            'text',
            false
        );
        $options[] = HTMLHelper::_(
            'select.option',
            2,
            Text::_('SR_FIELD_EXTRA_CHARGE_TYPE_PER_BOOKING_PER_STAY'),
            'value',
            'text',
            $disabled
        );
        $options[] = HTMLHelper::_(
            'select.option',
            3,
            Text::_('SR_FIELD_EXTRA_CHARGE_TYPE_PER_BOOKING_PER_PERSON'),
            'value',
            'text',
            $disabled
        );
        $options[] = HTMLHelper::_(
            'select.option',
            4,
            Text::_('SR_FIELD_EXTRA_CHARGE_TYPE_PER_ROOM_PER_STAY'),
            'value',
            'text',
            $disabled
        );
        $options[] = HTMLHelper::_(
            'select.option',
            5,
            Text::_('SR_FIELD_EXTRA_CHARGE_TYPE_PER_ROOM_PER_PERSON'),
            'value',
            'text',
            $disabled
        );
        $options[] = HTMLHelper::_(
            'select.option',
            6,
            Text::_('SR_FIELD_EXTRA_CHARGE_TYPE_PER_ROOM_PER_PERSON_PER_STAY'),
            'value',
            'text',
            $disabled
        );
        $options[] = HTMLHelper::_(
            'select.option',
            7,
            Text::_('SR_FIELD_EXTRA_CHARGE_TYPE_PERCENTAGE_OF_DAILY_RATE'),
            'value',
            'text',
            $disabled
        );
        $options[] = HTMLHelper::_(
            'select.option',
            8,
            Text::_('SR_FIELD_EXTRA_CHARGE_TYPE_EARLY_ARRIVAL_PERCENTAGE_OF_DAILY_RATE'),
            'value',
            'text',
            $disabled
        );

        return array_merge(parent::getOptions(), $options);
    }
}
