<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Component\Solidres\Administrator\Helper\SolidresHelper;

class CouponField extends FormField
{
    public $type = 'Coupon';

    protected function getInput()
    {
        $html       = [];
        $selectedId = (int)$this->form->getValue('coupon_id');
        $options    = SolidresHelper::getCouponOptions();

        $html[] = HTMLHelper::_('select.genericlist', $options, $this->name, null, 'value', 'text', $selectedId);

        return implode($html);
    }
}


