<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Form\Field\ListField;
use Joomla\Component\Solidres\Administrator\Helper\SolidresHelper;

class CustomergroupField extends ListField
{
    protected $type = 'CustomerGroup';

    protected $showall = null;

    public function getOptions()
    {
        $this->showall = isset($this->element['showall']) ? $this->element['showall']->__toString() : 'false';
        $this->showall = $this->showall == 'true';
        $options       = SolidresHelper::getCustomerGroupOptions($this->showall);

        return array_merge(parent::getOptions(), $options);
    }
}


