<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

class ReservationassetField extends ListField
{
    protected $type = 'ReservationAsset';

    protected function getOptions()
    {
        $options  = parent::getOptions();
        $multiple = $this->getAttribute('multiple');
        $app      = Factory::getApplication();

        if (empty($options) && (!$multiple || $multiple === 'false')) {
            $options = [HTMLHelper::_('select.option', '', Text::_('SR_FILTER_RESERVATION_ASSET_SELECT'))];
        }

        $mvcFactory = $app->bootComponent('com_solidres')->getMVCFactory();
        $raModel    = $mvcFactory->createModel('Reservationassets', 'Administrator', ['ignore_request' => true]);
        $raModel->setState('list.select', 'a.id AS value, a.name AS text');
        $raModel->setState('list.start', 0);
        $raModel->setState('list.limit', 0);
        $raModel->setState('filter.state', 1);
        $raModel->setState('list.ordering', 'a.name');
        $raModel->setState('hub.ignore', true);

        if ($app->isClient('site')) {
            $user          = $app->getIdentity();
            $customerTable = $mvcFactory->createTable('Customer', 'Administrator');
            $customerTable->load(['user_id' => $user->id]);
            $raModel->setState('filter.partner_id', $customerTable->id);
        }

        return array_merge($options, (array)$raModel->getItems());
    }
}
