<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Solidres\MVC\FactoryTrait;

/**
 * Supports an HTML select list of room types
 *
 * @package       Solidres
 * @subpackage    RoomType
 * @since         1.6
 */
class RoomtypeField extends ListField
{
    use FactoryTrait;

    protected $type = 'RoomType';

    protected function getOptions()
    {
        $options = [HTMLHelper::_('select.option', '', '')];
        $model   = $this->createModel('Roomtypes');
        $model->setState('list.select', 'r.id AS value, r.name AS text, asset.name AS reservationasset');
        $model->setState('list.start', 0);
        $model->setState('list.limit', 0);
        $model->setState('filter.state', 1);
        $model->setState('list.ordering', 'r.name');

        return array_merge($options, (array)$model->getItems());
    }
}
