<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Field\Solidres;

defined('_JEXEC') or die;

use Joomla\CMS\Form\FormField;
use Solidres\Layout\LayoutHelper;
use Solidres\Utility\Utility;

class MapField extends FormField
{
    protected $type = 'Solidres_Map';

    protected function getInput()
    {
        $lMap = Utility::getMapProvider() === 'OSM' ? 'map_osm' : 'map_gg';

        return LayoutHelper::render('solidres.form.field.' . $lMap, ['field' => $this]);
    }
}
