<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Form\Field\ListField;
use Joomla\Component\Solidres\Administrator\Helper\SolidresHelper;

/**
 * Supports an HTML select list of taxes
 *
 * @package
 * @subpackage
 * @since        1.6
 */
class TaxField extends ListField
{
    protected $type = 'Tax';

    protected function getOptions()
    {
        $assetId   = (int)$this->form->getValue('reservation_asset_id');
        $countryId = (int)$this->form->getValue('country_id', null, 0);
        $options   = SolidresHelper::getTaxOptions($assetId, $countryId);

        return array_merge(parent::getOptions(), $options);
    }
}
