<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Field;

defined('_JEXEC') or die;

use DateTimeZone;
use Joomla\CMS\Form\Field\TextField;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Database\DatabaseInterface;
use Solidres\Utility\Utility;
use Solidres\Version;

class UidatepickerField extends TextField
{
    protected $type = 'UIDatepicker';

    protected function getInput()
    {
        $app        = Factory::getApplication();
        $config     = $app->getConfig();
        $user       = $app->getIdentity();
        $filter     = $this->getAttribute('filter', 'user_utc');
        $dateFormat = ComponentHelper::getParams('com_solidres')->get('date_format', 'd-m-Y');
        $jsFormat   = Utility::convertDateFormatPattern($dateFormat);
        $nullDate   = Factory::getContainer()->get(DatabaseInterface::class)->getNullDate();

        switch (strtoupper($filter)) {
            case 'SERVER_UTC':

                if ($this->value && $this->value != $nullDate) {
                    $date = Factory::getDate($this->value, 'UTC');
                    $date->setTimezone(new DateTimeZone($config->get('offset')));
                    $this->value = $date->format('Y-m-d H:i:s', true, false);
                }

                break;

            case 'USER_UTC':

                if ($this->value && $this->value != $nullDate) {
                    $date = Factory::getDate($this->value, 'UTC');
                    $date->setTimezone($user->getTimezone());
                    $this->value = $date->format('Y-m-d H:i:s', true, false);
                }

                break;
        }

        if ($this->value && $this->value != $nullDate && strtotime($this->value) !== false) {
            $tz = date_default_timezone_get();
            date_default_timezone_set('UTC');
            $this->value = date('Y-m-d', strtotime($this->value));
            date_default_timezone_set($tz);
            $formatValue = Factory::getDate($this->value)->format($dateFormat, true);
        } else {
            $this->value = '';
            $formatValue = '';
        }

        $id      = preg_replace('/[^0-9a-z\_\-]/i', '', $this->id);
        $options = [
            'dateFormat' => $jsFormat,
            'altField'   => '#' . $id,
            'altFormat'  => 'yy-mm-dd',
        ];

        $extraOptions = [
            'showButtonPanel' => false,
            'changeMonth'     => false,
            'changeYear'      => false,
            'numberOfMonths'  => ComponentHelper::getParams('com_solidres')->get('datepicker_month_number', 1),
        ];

        foreach ($extraOptions as $name => $value) {
            $option         = $this->getAttribute($name, null);
            $options[$name] = null === $option ? $value : $option;

            if (is_numeric($options[$name])) {
                $options[$name] = (int)$options[$name];
            }
        }

        if ($minDate = $this->getAttribute('minDate', null)) {
            $options['minDate'] = $minDate;
        }

        if ($maxDate = $this->getAttribute('maxDate', null)) {
            $options['maxDate'] = $maxDate;
        }

        $onSelect = trim($this->getAttribute('onSelect', ''));

        \Solidres\HTML\HTMLHelper::_('jquery.ui');
        HTMLHelper::_(
            'script',
            'com_solidres/assets/datePicker/localization/jquery.ui.datepicker-' . $app->getLanguage()->getTag() . '.js',
            ['version' => Version::getHashVersion(), 'relative' => true]
        );
        $app->getDocument()->addScriptDeclaration(
            'Solidres.jQuery(document).ready(function($) {	
			var alias = $("#' . $id . '-alias");
			var dateInput = $("#' . $id . '");
			var onSelect = ' . ($onSelect ?: 'false') . ';
			var options = ' . json_encode($options) . ';
			
			if (typeof onSelect === "function") {
				options.onSelect = onSelect;
			}
			
			alias.trigger("onBeforeInitDatePicker", options);
			alias.datepicker(options);
			alias.on("change", function() {
			
				if (this.value == "") {
					dateInput.val("");
				}
				
				dateInput.trigger("change");
			});		
			
			$("#' . $id . '-btn").on("click", function() {
				if (!alias.datepicker("widget").is(":visible")) {
					alias.datepicker("show");
				}
			});
		});'
        );

        $required              = $this->getAttribute('required');
        $onChange              = empty($this->onchange) ? '' : ' onchange="' . $this->onchange . '"';
        $required              = empty($required) || $required == '0' || $required == '1' ? '' : ' required="required"';
        $hint                  = $this->hint ? ' placeholder="' . Text::_($this->hint) . '"' : '';
        $inputClass            = 'form-control';
        $inputAppendClass      = SR_UI_INPUT_APPEND;
        $inputAppendAddonClass = SR_UI_INPUT_ADDON;

        return <<<HTML
			<div class="sr-field-ui-datepicker-container {$inputAppendClass}">
				<input type="text" id="{$id}-alias" value="{$formatValue}" autocomplete="off" readonly{$hint}{$required} class="{$inputClass}"/>
				<span class="{$inputAppendAddonClass}" id="{$id}-btn">
					<i class="fa fa-calendar"></i>	
				</span>					
			</div>
			<input type="hidden" id="{$id}" name="{$this->name}" value="{$this->value}"{$onChange}/>
HTML;
    }
}
