<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Model\ListModel;
use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;

class CountriesModel extends ListModel
{
    public function __construct($config = [])
    {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = [
                'id',
                'r.id',
                'name',
                'r.name',
                'code_2',
                'r.code_2',
                'code_3',
                'r.code_3',
                'state',
                'r.state',
                'checked_out',
                'r.checked_out',
                'checked_out_time',
                'r.checked_out_time',
                'created_by',
                'r.created_by',
                'created_date',
                'r.created_date',
                'modified_by',
                'r.modified_by',
                'modified_date',
                'r.modified_date',
                'state',
            ];
        }

        parent::__construct($config);
    }

    protected function populateState($ordering = 'r.name', $direction = 'asc')
    {
        // Initialise variables.
        $app = Factory::getApplication();

        // Load the filter state.
        $search = $app->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
        $this->setState('filter.search', $search);

        $published = $app->getUserStateFromRequest($this->context . '.filter.state', 'filter_state', '', 'string');
        $this->setState('filter.state', $published);

        // Load the parameters.
        $params = ComponentHelper::getParams('com_solidres');
        $this->setState('params', $params);

        // List state information.
        parent::populateState($ordering, $direction);
    }

    protected function getListQuery()
    {
        // Create a new query object.
        $db    = $this->getDatabase();
        $query = $db->getQuery(true);

        // Select the required fields from the table.
        $query->select(
            $this->getState(
                'list.select',
                'r.*'
            )
        );

        $query->from($db->quoteName('#__sr_countries') . ' AS r');

        // Filter by published state
        $published = $this->getState('filter.state');
        if (is_numeric($published)) {
            $query->where('r.state = ' . (int)$published);
        } else {
            if ($published === '') {
                $query->where('(r.state IN (0, 1))');
            }
        }

        // Filter by search in title
        $search = $this->getState('filter.search');
        if (!empty($search)) {
            if (stripos($search, 'id:') === 0) {
                $query->where('r.id = ' . (int)substr($search, 3));
            } else {
                $search = $db->quote('%' . $db->escape($search, true) . '%');
                $query->where('r.name LIKE ' . $search);
            }
        }

        // Add the list ordering clause.
        $orderCol  = $this->state->get('list.ordering', 'r.name');
        $orderDirn = $this->state->get('list.direction', 'ASC');

        $query->order($db->escape($orderCol) . ' ' . $db->escape($orderDirn));

        return $query;
    }
}
