<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Solidres\MVC\Model\AdminModel;

class CountryModel extends AdminModel
{
    public function getForm($data = [], $loadData = true)
    {
        if (!($form = parent::getForm($data, $loadData))) {
            return false;
        }

        // Determine correct permissions to check.
        if ($this->getState('country.id')) {
            // Existing record. Can only edit in selected categories.
            $form->setFieldAttribute('catid', 'action', 'core.edit');
        } else {
            // New record. Can only create in selected categories.
            $form->setFieldAttribute('catid', 'action', 'core.create');
        }

        return $form;
    }

    protected function prepareTable($table)
    {
        $date = Factory::getDate();
        $user = Factory::getApplication()->getIdentity();

        $table->name          = htmlspecialchars_decode($table->name, ENT_QUOTES);
        $table->modified_date = $date->toSql();
        $table->modified_by   = $user->id;
    }
}
