<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\Utilities\ArrayHelper;
use Solidres\Media\ImageUploaderTrait;
use Solidres\MVC\Model\AdminModel;
use Solidres\Utility\Utility;
use Throwable;

class CouponModel extends AdminModel
{
    use ImageUploaderTrait;

    protected function getAssetIds($couponId)
    {
        $db    = $this->getDatabase();
        $query = $db->getQuery(true)
            ->select('a.item_id')
            ->from($db->quoteName('#__sr_coupon_item_xref', 'a'))
            ->innerJoin($db->quoteName('#__sr_coupons', 'a2') . ' ON a2.id = a.coupon_id')
            ->where('a2.scope = 0 AND a.coupon_id = ' . (int)$couponId);
        $db->setQuery($query);

        return $db->loadColumn();
    }

    protected function canDelete($record)
    {
        $app  = Factory::getApplication();
        $user = $app->getIdentity();

        if (!$app->isClient('administrator') && ($assetIds = $this->getAssetIds($record->id))) {
            $userId = $user->id;

            foreach ($assetIds as $assetId) {
                if (!Utility::isAssetPartner($userId, $assetId)) {
                    return false;
                }
            }

            return true;
        }

        return parent::canDelete($record);
    }

    protected function canEditState($record)
    {
        $app  = Factory::getApplication();
        $user = $app->getIdentity();

        if (!$app->isClient('administrator') && ($assetIds = $this->getAssetIds($record->id))) {
            $userId = $user->id;

            foreach ($assetIds as $assetId) {
                if (!Utility::isAssetPartner($userId, $assetId)) {
                    return false;
                }
            }

            return true;
        }

        return parent::canEditState($record);
    }

    public function getItem($pk = null)
    {
        $item = parent::getItem($pk);

        if ($item->id) {
            $config                   = Factory::getApplication()->getConfig();
            $tzoffset                 = $config->get('offset');
            $item->valid_from         = Factory::getDate($item->valid_from, $tzoffset)->toUnix();
            $item->valid_to           = Factory::getDate($item->valid_to, $tzoffset)->toUnix();
            $item->valid_from_checkin = Factory::getDate($item->valid_from_checkin, $tzoffset)->toUnix();
            $item->valid_to_checkin   = Factory::getDate($item->valid_to_checkin, $tzoffset)->toUnix();

            $db    = $this->getDatabase();
            $query = $db->getQuery(true)
                ->select('a.item_id')
                ->from($db->quoteName('#__sr_coupon_item_xref', 'a'))
                ->innerJoin($db->quoteName('#__sr_coupons', 'a2') . ' ON a2.id = a.coupon_id')
                ->where('a2.scope = 0 AND a.coupon_id = ' . (int)$item->id);
            $db->setQuery($query);

            if ($itemIds = $db->loadColumn()) {
                $item->reservation_asset_id = $itemIds;
            } else {
                if (empty($item->reservation_asset_id)) {
                    $item->reservation_asset_id = [];
                } else {
                    $item->reservation_asset_id = [$item->reservation_asset_id];
                }
            }
        }

        return $item;
    }

    protected function prepareTable($table)
    {
        if ($table->customer_group_id === '' || $table->customer_group_id === 'NULL') {
            $table->customer_group_id = null;
        }

        if ($table->quantity === '') {
            $table->quantity = null;
        }
    }

    /**
     *
     * This is just an overridden methods to let the model know that it need to update the NULL data
     *
     * Method to save the form data.
     *
     * @param array $data The form data.
     *
     * @return  boolean  True on success, False on error.
     *
     * @since   12.2
     */
    public function save($data)
    {
        $pk    = (!empty($data['id'])) ? $data['id'] : (int)$this->getState('coupon.id');
        $isNew = empty($pk);
        $itemIds = [];

        if (!empty($data['reservation_asset_id'])) {
            foreach ($data['reservation_asset_id'] as $itemId) {
                $itemId = (int)$itemId;

                if ($itemId > 0 && !in_array($itemId, $itemIds)) {
                    $itemIds[] = $itemId;
                }
            }
        }

        $data['reservation_asset_id'] = null;
        $db                           = $this->getDatabase();
        $isSite                       = Factory::getApplication()->isClient('site');
        $partnerIds                   = Utility::getPartnerIds();

        if ($isSite && !$isNew && $partnerIds) {
            $query    = $db->getQuery(true)
                ->select('a.id')
                ->from($db->quoteName('#__sr_coupons', 'a'))
                ->join('INNER', $db->quoteName('#__sr_coupon_item_xref', 'a2') . ' ON a2.coupon_id = a.id')
                ->join('INNER', $db->quoteName('#__sr_reservation_assets', 'a3') . ' ON a3.id = a2.item_id')
                ->where(
                    'a.scope = 0 AND (a3.partner_id IS NULL OR a3.partner_id < 1 OR a3.partner_id NOT IN (' . implode(
                        ',',
                        $partnerIds
                    ) . '))'
                );
            $notInIds = $db->setQuery($query)->loadColumn();

            if ($notInIds && in_array($pk, $notInIds)) {
                $this->setError(Text::sprintf('SR_ERR_THE_COUPON_IS_NOT_YOUR_MSG_FORMAT', $data['coupon_code']));

                return false;
            }
        }

        if ($result = parent::save($data)) {
            $couponId = (int)$this->getState('coupon.id');

            if ($isSite && $partnerIds) {
                $query = $db->getQuery(true)
                    ->select('a.item_id')
                    ->from($db->quoteName('#__sr_coupon_item_xref', 'a'))
                    ->innerJoin($db->quoteName('#__sr_coupons', 'a2') . ' ON a2.id = a.coupon_id')
                    ->innerJoin($db->quoteName('#__sr_reservation_assets', 'a3') . ' ON a3.id = a.item_id')
                    ->where('a2.scope = 0 AND a.coupon_id = ' . $couponId)
                    ->where(
                        '(a3.partner_id IS NULL OR a3.partner_id < 1 OR a3.partner_id NOT IN (' . join(
                            ',',
                            $partnerIds
                        ) . '))'
                    );
                $db->setQuery($query);

                if ($prevItemIds = $db->loadColumn()) {
                    $itemIds = array_merge($prevItemIds, $itemIds);
                    $itemIds = ArrayHelper::toInteger($itemIds);
                    $itemIds = ArrayHelper::arrayUnique($itemIds);
                }
            }

            $query = $db->getQuery(true)
                ->delete($db->quoteName('#__sr_coupon_item_xref'))
                ->where($db->quoteName('coupon_id') . ' = ' . $couponId);
            $db->setQuery($query)
                ->execute();

            if ($itemIds) {
                $query->clear()
                    ->insert($db->quoteName('#__sr_coupon_item_xref'))
                    ->columns($db->quoteName(['coupon_id', 'item_id']));

                foreach ($itemIds as $itemId) {
                    $query->values($couponId . ', ' . $itemId);
                }

                $db->setQuery($query)
                    ->execute();
            }

            try {
                $this->uploadMedia($couponId);
            } catch (Throwable $e) {
            }
        }

        return $result;
    }
}
