<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Model\ListModel;
use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;

class CurrenciesModel extends ListModel
{
    public function __construct($config = [])
    {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = [
                'id',
                'u.id',
                'currency_name',
                'u.currency_name',
                'currency_code',
                'u.currency_code',
                'state',
                'u.state',
                'exchange_rate',
                'u.exchange_rate',
            ];
        }

        parent::__construct($config);
    }

    protected function populateState($ordering = 'u.currency_name', $direction = 'asc')
    {
        // Initialise variables.
        $app = Factory::getApplication();

        // Load the filter state.
        $search = $app->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
        $this->setState('filter.search', $search);

        $published = $app->getUserStateFromRequest($this->context . '.filter.state', 'filter_state', '', 'string');
        $this->setState('filter.state', $published);

        // Load the parameters.
        $params = ComponentHelper::getParams('com_solidres');
        $this->setState('params', $params);

        // List state information.
        parent::populateState($ordering, $direction);
    }

    protected function getListQuery()
    {
        $db    = $this->getDatabase();
        $query = $db->getQuery(true);

        $query->select($this->getState('list.select', 'u.*'));

        $query->from($db->quoteName('#__sr_currencies') . ' AS u');

        $published = $this->getState('filter.state');
        if (is_numeric($published)) {
            $query->where('u.state = ' . (int)$published);
        } else {
            if ($published === '') {
                $query->where('(u.state IN (0, 1))');
            }
        }

        // Filter by search in title
        $search = $this->getState('filter.search');
        if (!empty($search)) {
            if (stripos($search, 'id:') === 0) {
                $query->where('u.id = ' . (int)substr($search, 3));
            } else {
                $search = $db->quote('%' . $db->escape($search, true) . '%');
                $query->where('u.currency_name LIKE ' . $search . ' OR u.currency_code LIKE' . $search);
            }
        }

        // Add the list ordering clause.
        $orderCol  = $this->state->get('list.ordering', 'u.currency_name');
        $orderDirn = $this->state->get('list.direction', 'ASC');

        $query->order($db->escape($orderCol) . ' ' . $db->escape($orderDirn));

        return $query;
    }
}
