<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Solidres\MVC\Model\AdminModel;
use Joomla\CMS\Factory as CMSFactory;

class OriginModel extends AdminModel
{
    public function getForm($data = [], $loadData = true)
    {
        if (!($form = parent::getForm($data, $loadData))) {
            return false;
        }

        $scope = (int)CMSFactory::getApplication()->getUserStateFromRequest(
            'com_solidres.origins.filter.scope',
            'scope',
            0,
            'uint'
        );
        $form->setValue('scope', null, $scope);

        return $form;
    }

    protected function canEditState($record)
    {
        if ($record->is_default && 1 !== $record->state) {
            CMSFactory::getApplication()->enqueueMessage(Text::_('SR_WARN_DEFAULT_ORIGIN_IS_PROTECTED_MSG'), 'warning');

            return false;
        }

        return parent::canEditState($record);
    }

    protected function prepareTable($table)
    {
        // If tax_id is empty, then set it to null
        if (empty($table->tax_id)) {
            $table->tax_id = null;
        }
    }
}
