<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Solidres\MVC\Model\AdminModel;
use Solidres\Utility\Utility;

class RoomModel extends AdminModel
{
    protected function canDelete($record)
    {
        $app  = Factory::getApplication();
        $user = $app->getIdentity();

        if ($app->isClient('api')) {
            // Authorization has already checked from the ApiController
            return true;
        }

        if ($app->isClient('administrator')) {
            return parent::canDelete($record);
        } else {
            $tableRoomType = $this->getTable('RoomType');
            $tableRoomType->load($record->room_type_id);

            return Utility::isAssetPartner($user->id, $tableRoomType->reservation_asset_id);
        }
    }

    protected function prepareTable($table)
    {
        $table->label = htmlspecialchars_decode($table->label, ENT_QUOTES);
    }

    protected function canEditState($record)
    {
        $app  = Factory::getApplication();
        $user = $app->getIdentity();

        if ($app->isClient('administrator')) {
            return parent::canEditState($record);
        } else {
            $tableRoomType = $this->getTable('RoomType');
            $tableRoomType->load($record->room_type_id);

            return Utility::isAssetPartner($user->id, $tableRoomType->reservation_asset_id);
        }
    }
}
