<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Solidres\MVC\Model\AdminModel;
use Joomla\CMS\Language\Text;

class StatusModel extends AdminModel
{
    public function getForm($data = [], $loadData = true)
    {
        $form = $this->loadForm('com_solidres.status', 'status', ['control' => 'jform', 'load_data' => $loadData]);

        if (empty($form)) {
            return false;
        }

        $scope = (int)Factory::getApplication()->getUserStateFromRequest('com_solidres.statuses.filter.scope', 0);
        $form->setValue('scope', null, $scope);

        if ($form->getValue('readonly')) {
            $form->setFieldAttribute('code', 'readonly', 'true');
            $form->setFieldAttribute('type', 'readonly', 'true');
        }

        return $form;
    }

    public function canDelete($record)
    {
        if ($record->readonly) {
            Factory::getApplication()->enqueueMessage(Text::_('SR_ERR_CANNOT_DELETE_THE_READONLY_STATUS'), 'error');

            return false;
        }

        return parent::canDelete($record);
    }
}
