<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Table;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;

class StatusTable extends Table
{
    public function __construct(DatabaseDriver $db)
    {
        parent::__construct('#__sr_statuses', 'id', $db);
        $this->setColumnAlias('published', 'state');
    }

    public function check()
    {
        $table    = clone $this;
        $loadData = [
            'scope' => $this->scope,
            'code'  => $this->code,
            'type'  => $this->type,
        ];

        if ($table->load($loadData)
            && (empty($this->id) || $table->id != $this->id)
        ) {
            $this->setError(Text::sprintf('SR_ERR_THE_CODE_EXISTS_FORMAT', $this->code));

            return false;
        }

        return true;
    }
}
