<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Table;

defined('_JEXEC') or die;

use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;

class TaxTable extends Table
{
    public function __construct(DatabaseDriver $db)
    {
        parent::__construct('#__sr_taxes', 'id', $db);

        $this->setColumnAlias('published', 'state');
    }

    public function delete($pk = null)
    {
        $query = $this->_db->getQuery(true);

        $query->update($this->_db->quoteName('#__sr_reservation_assets'))
            ->set($this->_db->quoteName('tax_id') . ' = NULL')
            ->where($this->_db->quoteName('tax_id') . ' = ' . $pk);

        $this->_db->setQuery($query)->execute();

        if (PluginHelper::isEnabled('solidres', 'experience')) {
            $query->clear();
            $query->update($this->_db->quoteName('#__sr_experiences'))
                ->set($this->_db->quoteName('tax_id') . ' = NULL')
                ->where($this->_db->quoteName('tax_id') . ' = ' . $pk);

            $this->_db->setQuery($query)->execute();
        }

        // Delete itself, finally
        return parent::delete($pk);
    }
}

