<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\View\Country;

defined('_JEXEC') or die;

use Exception;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Language\Text;
use Joomla\Component\Solidres\Administrator\Helper\SolidresHelper;
use Solidres\Version;

class HtmlView extends BaseHtmlView
{
    protected $state;
    protected $item;
    protected $form;

    public function display($tpl = null)
    {
        $this->state = $this->get('State');
        $this->form  = $this->get('Form');

        if ($errors = $this->get('Errors')) {
            throw new Exception(implode(PHP_EOL, $errors), 500);
        }

        HTMLHelper::_(
            'stylesheet',
            'com_solidres/assets/main.min.css',
            ['version' => Version::getHashVersion(), 'relative' => true]
        );

        $this->addToolbar();

        parent::display($tpl);
    }

    protected function addToolbar()
    {
        Factory::getApplication()->getInput()->set('hidemainmenu', true);
        $user       = $this->getCurrentUser();
        $id         = $this->form->getValue('id');
        $isNew      = ($id == 0);
        $checkedOut = !($this->form->getValue('checked_out') == 0 || $this->form->getValue('checked_out') == $user->get(
                'id'
            ));
        $canDo      = SolidresHelper::getActions('', $this->form->getValue('id'));

        if ($isNew) {
            ToolbarHelper::title(Text::_('SR_ADD_NEW_COUNTRY'));
        } else {
            ToolbarHelper::title(Text::_('SR_EDIT_COUNTRY'));
        }

        // If not checked out, can save the item.
        if (!$checkedOut && $canDo->get('core.edit')) {
            ToolbarHelper::apply('country.apply');
            ToolbarHelper::save('country.save');
            ToolbarHelper::save2new('country.save2new');
        }

        // If an existing item, can save to a copy.
        if (!$isNew && $canDo->get('core.create')) {
            ToolbarHelper::save2copy('country.save2copy');
        }

        ToolbarHelper::cancel('country.cancel', empty($id) ? 'JToolbar_Cancel' : 'JToolbar_Close');

        ToolbarHelper::inlinehelp();
    }
}
