<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\View\Customergroups;

defined('_JEXEC') or die;

use Exception;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Language\Text;
use Joomla\Component\Solidres\Administrator\Helper\SolidresHelper;
use Solidres\Version;

class HtmlView extends BaseHtmlView
{
    protected $state;
    protected $items;
    protected $pagination;

    public function display($tpl = null)
    {
        $this->state         = $this->get('State');
        $this->items         = $this->get('Items');
        $this->pagination    = $this->get('Pagination');
        $this->filterForm    = $this->get('FilterForm');
        $this->activeFilters = $this->get('ActiveFilters');

        if ($errors = $this->get('Errors')) {
            throw new Exception(implode(PHP_EOL, $errors), 500);
        }

        HTMLHelper::_(
            'stylesheet',
            'com_solidres/assets/main.min.css',
            ['version' => Version::getHashVersion(), 'relative' => true]
        );

        $this->addToolbar();

        parent::display($tpl);
    }


    protected function addToolbar()
    {
        $state = $this->get('State');
        $canDo = SolidresHelper::getActions();

        ToolbarHelper::title(Text::_('SR_MANAGE_CUSTOMER_GROUP'));

        if ($canDo->get('core.create')) {
            ToolbarHelper::addNew('customergroup.add');
        }

        if ($canDo->get('core.edit')) {
            ToolbarHelper::editList('customergroup.edit');
        }

        if ($canDo->get('core.edit.state')) {
            ToolbarHelper::custom('customergroups.publish', 'publish.png', 'publish_f2.png', 'JTOOLBAR_PUBLISH', true);
            ToolbarHelper::custom(
                'customergroups.unpublish',
                'unpublish.png',
                'unpublish_f2.png',
                'JTOOLBAR_UNPUBLISH',
                true
            );
        }

        if ($state->get('filter.state') == -2 && $canDo->get('core.delete')) {
            ToolbarHelper::deleteList('', 'customergroups.delete', 'JTOOLBAR_EMPTY_TRASH');
        } elseif ($canDo->get('core.edit.state')) {
            ToolbarHelper::trash('customergroups.trash');
        }
    }
}
