<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\View\Reservationassets;

defined('_JEXEC') or die;

use Exception;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Language\Text;
use Solidres\Version;

class HtmlView extends BaseHtmlView
{
    protected $state;
    protected $items;
    protected $pagination;

    public function display($tpl = null)
    {
        $this->state         = $this->get('State');
        $this->items         = $this->get('Items');
        $this->pagination    = $this->get('Pagination');
        $this->filterForm    = $this->get('FilterForm');
        $this->activeFilters = $this->get('ActiveFilters');

        if ($errors = $this->get('Errors')) {
            throw new Exception(implode(PHP_EOL, $errors), 500);
        }

        HTMLHelper::_(
            'stylesheet',
            'com_solidres/assets/main.min.css',
            ['version' => Version::getHashVersion(), 'relative' => true]
        );
        parent::display($tpl);
        $this->addToolbar();
    }

    protected function addToolbar()
    {
        $user = $this->getCurrentUser();
        ToolbarHelper::title(Text::_('SR_MANAGER_ASSETS'));

        if ($user->authorise('core.create', 'com_solidres')) {
            ToolbarHelper::addNew('reservationasset.add');
        }

        if ($user->authorise('core.edit', 'com_solidres')) {
            ToolbarHelper::editList('reservationasset.edit');
        }

        if ($user->authorise('core.edit.state', 'com_solidres')) {
            ToolbarHelper::publish('reservationassets.publish', 'JTOOLBAR_PUBLISH', true);
            ToolbarHelper::unpublish('reservationassets.unpublish', 'JTOOLBAR_UNPUBLISH', true);
        }

        if ($this->state->get('filter.state') == -2 && $user->authorise('core.delete', 'com_solidres')) {
            ToolbarHelper::deleteList('', 'reservationassets.delete', 'JTOOLBAR_EMPTY_TRASH');
        } elseif ($user->authorise('core.edit.state', 'com_solidres')) {
            ToolbarHelper::trash('reservationassets.trash');
        }

        if ($user->authorise('core.admin', 'com_solidres')) {
            ToolbarHelper::preferences('com_solidres');
        }
    }
}
