<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\View\Reservations;

defined('_JEXEC') or die;

use Exception;
use JLoader;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\Component\Solidres\Administrator\Helper\SolidresHelper;
use Solidres\Version;

class HtmlView extends BaseHtmlView
{
    protected $state;
    protected $items;
    protected $pagination;

    public function display($tpl = null)
    {
        $this->state          = $this->get('State');
        $this->items          = $this->get('Items');
        $this->pagination     = $this->get('Pagination');
        $this->filterForm     = $this->get('FilterForm');
        $this->activeFilters  = $this->get('ActiveFilters');
        $this->solidresConfig = ComponentHelper::getParams('com_solidres');
        $this->dateFormat     = $this->solidresConfig->get('date_format', 'd-m-Y');

        if ($errors = $this->get('Errors')) {
            throw new Exception(implode(PHP_EOL, $errors), 500);
        }

        HTMLHelper::_(
            'stylesheet',
            'com_solidres/assets/main.min.css',
            ['version' => Version::getHashVersion(), 'relative' => true]
        );

        if (PluginHelper::isEnabled('solidres', 'channelmanager')) {
            JLoader::register('plgSolidresChannelManager', SRPATH_LIBRARY . '/channelmanager/channelmanager.php');
        }

        $this->addToolbar();

        parent::display($tpl);
    }


    protected function addToolbar()
    {
        $state = $this->get('State');
        $canDo = SolidresHelper::getActions();

        ToolbarHelper::title(Text::_('SR_MANAGE_RESERVATION'));

        if ($canDo->get('core.create')) {
            ToolbarHelper::addNew('reservationbase.add');
        }

        if ($canDo->get('core.edit')) {
            ToolbarHelper::custom('reservationbase.edit', 'eye', '', 'JTOOLBAR_VIEW', true);
            ToolbarHelper::custom('reservationbase.amend', 'edit', '', 'JTOOLBAR_AMEND', true);
            ToolbarHelper::custom('reservations.export', 'download', '', 'SR_RESERVATION_EXPORT', true);
        }

        if ($state->get('filter.state') == [$this->solidresConfig->get('trashed_state', -2)] && $canDo->get(
                'core.delete'
            )) {
            ToolbarHelper::deleteList('', 'reservations.delete', 'JTOOLBAR_EMPTY_TRASH');
        } else {
            if ($canDo->get('core.edit.state')) {
                ToolbarHelper::trash('reservations.trash');
            }
        }

        \Solidres\Toolbar\ToolbarHelper::printTable();

        if ($canDo->get('core.admin')) {
            ToolbarHelper::preferences('com_solidres');
        }
    }
}
