<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\View\State;

defined('_JEXEC') or die;

use Exception;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\Component\Solidres\Administrator\Helper\SolidresHelper;
use Solidres\Version;

class HtmlView extends BaseHtmlView
{
    protected $state;
    protected $form;

    public function display($tpl = null)
    {
        $this->state = $this->get('State');
        $this->form  = $this->get('Form');

        if ($errors = $this->get('Errors')) {
            throw new Exception(implode(PHP_EOL, $errors), 500);
        }

        HTMLHelper::_(
            'stylesheet',
            'com_solidres/assets/main.min.css',
            ['version' => Version::getHashVersion(), 'relative' => true]
        );

        $this->addToolbar();

        parent::display($tpl);
    }


    protected function addToolbar()
    {
        Factory::getApplication()->getInput()->set('hidemainmenu', true);
        $id = $this->form->getValue('id');
        $isNew = ($id == 0);
        $canDo = SolidresHelper::getActions('', $id);

        if ($isNew) {
            ToolbarHelper::title(Text::_('SR_ADD_NEW_STATE'));
        } else {
            ToolbarHelper::title(Text::_('SR_EDIT_STATE'));
        }

        // If not checked out, can save the item.
        if ($canDo->get('core.edit')) {
            ToolbarHelper::apply('state.apply');
            ToolbarHelper::save('state.save');
            ToolbarHelper::save2new('state.save2new');
        }

        // If an existing item, can save to a copy.
        if (!$isNew && $canDo->get('core.create')) {
            ToolbarHelper::save2copy('state.save2copy');
        }

        ToolbarHelper::cancel('state.cancel', empty($id) ? 'JToolbar_Cancel' : 'JToolbar_Close');

        ToolbarHelper::inlinehelp();
    }
}
