<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Solidres\Layout\LayoutHelper;
use Solidres\Utility\Utility;

?>
    <h3><?php echo Text::_('SR_GENERAL_INFO', true) ?></h3>

<?php
$reservationObj = $this->form->getData()->toObject();
$displayData    = [
    'reservation'         => $reservationObj,
    'costs'               => Utility::prepareReservationCosts($reservationObj),
    'dateFormat'          => $this->solidresConfig->get('date_format', 'd-m-Y'),
    'reservationMeta'     => $this->reservationMeta,
    'originValue'         => $this->originValue,
    'originText'          => $this->originText,
    'isCustomerDashboard' => false,
    'baseCurrency'        => $this->baseCurrency,
];
echo LayoutHelper::render('reservation.general_details', $displayData);
