<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Site\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Plugin\PluginHelper;
use SRExperienceHelper;

abstract class AssociationHelper
{
    public static function getAssociations($id = 0, $view = null)
    {
        $input = Factory::getApplication()->getInput();
        $view  = $view === null ? $input->get('view') : $view;
        $id    = empty($id) ? $input->getInt('id') : $id;

        if ($view === 'experience' && PluginHelper::isEnabled('solidres', 'experience')) {
            if ($id) {
                $associations = Associations::getAssociations(
                    'com_solidres',
                    '#__sr_experiences',
                    'com_solidres.experience',
                    $id,
                    'id',
                    null,
                    null
                );
                $return       = [];

                foreach ($associations as $tag => $item) {
                    $return[$tag] = SRExperienceHelper::getItemRoute($item->id);
                }

                return $return;
            }
        }

        return [];
    }
}
