<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Site\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Event\Content\ContentPrepareEvent;
use Joomla\CMS\Event\Model\PrepareDataEvent;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Solidres\Event\SolidresAssetViewLoadEvent;
use Solidres\Event\SolidresBaseEvent;
use stdClass;

class ApartmentModel extends BaseDatabaseModel
{
    public function getResources($roomTypeId = 0)
    {
        $app = Factory::getApplication();

        if (!$roomTypeId) {
            $roomTypeId = $app->input->get('id', 0, 'uint');
        }

        $db    = $this->getDatabase();
        $query = $db->getQuery(true)
            ->select('a.reservation_asset_id')
            ->from($db->quoteName('#__sr_room_types', 'a'))
            ->join('INNER', $db->quoteName('#__sr_reservation_assets', 'a2') . ' ON a2.id = a.reservation_asset_id')
            ->where('a.state = 1 AND a2.state = 1 AND a.id = ' . (int)$roomTypeId);
        $db->setQuery($query);

        if ($propertyId = $db->loadResult()) {
            $propertyModel = $this->getMVCFactory()->createModel(
                'ReservationAsset',
                'Administrator',
                ['ignore_request' => true]
            );
            $property      = $propertyModel->getItem($propertyId);

            if (!empty($property->roomTypes)) {
                $dispatcher = SolidresBaseEvent::getDispatcher();

                foreach ($property->roomTypes as $roomType) {
                    if ($roomType->id == $roomTypeId) {
                        $dispatcher->dispatch(
                            'onContentPrepare',
                            new ContentPrepareEvent(
                                'onContentPrepare',
                                [
                                    'context' => 'com_solidres.asset',
                                    'subject' => $property,
                                    'params'  => $property->params,
                                    'page'    => 0,
                                ]
                            )
                        );

                        SolidresAssetViewLoadEvent::dispatch(['subject' => $property]);
                        $dispatcher->dispatch(
                            'onRoomTypePrepareData',
                            new PrepareDataEvent(
                                'onRoomTypePrepareData',
                                [
                                    'context' => 'com_solidres.roomtype',
                                    'data'    => $roomType,
                                    'subject' => new stdClass(),
                                ]
                            )
                        );

                        return [$property, $roomType];
                    }
                }
            }
        }

        return false;
    }

    public function hit($pk = 0)
    {
        $input    = Factory::getApplication()->input;
        $hitcount = $input->getInt('hitcount', 1);

        if ($hitcount) {
            $pk = (!empty($pk)) ? $pk : (int)$this->getState('reservationasset.id');

            $table = $this->getMVCFactory()->createTable('ReservationAsset', 'Administrator');
            $table->hit($pk);
        }

        return true;
    }
}
