<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Site\View\Map;

defined('_JEXEC') or die;

use Exception;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Solidres\Version;

class HtmlView extends BaseHtmlView
{
    protected $property;

    public function display($tpl = null)
    {
        $app = Factory::getApplication();
        $propertyId = $app->getInput()->getUint('id');

        if ($propertyId > 0) {
            $propertyTable = $app->bootComponent('com_solidres')->getMVCFactory()->createTable(
                'ReservationAsset',
                'Administrator'
            );
            $propertyTable->load($propertyId);
            $this->property = $propertyTable;
        }

        HTMLHelper::_('jquery.framework');
        HTMLHelper::_(
            'stylesheet',
            'com_solidres/assets/main.min.css',
            ['version' => Version::getHashVersion(), 'relative' => true]
        );

        if ($errors = $this->get('Errors')) {
            throw new Exception(implode(PHP_EOL, $errors), 500);
        }

        parent::display($tpl);
    }
}
