<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Site\View\Reservation;

defined('_JEXEC') or die;

use Exception;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Solidres\Event\SolidresReservationFinalScreenDisplayEvent;
use Solidres\Utility\Utility;
use Solidres\Version;

class HtmlView extends BaseHtmlView
{
    public $reservation = null;

    public function display($tpl = null)
    {
        $this->context           = 'com_solidres.reservation.process';
        $this->config            = ComponentHelper::getParams('com_solidres');
        $this->showPoweredByLink = $this->config->get('show_solidres_copyright', '1');
        $this->app               = Factory::getApplication();
        $this->id                = $this->app->input->getUint('id', 0);
        $this->code              = $this->app->input->getString('code', '');
        $mvcFactory              = $this->app->bootComponent('com_solidres')->getMVCFactory();

        if ($this->id > 0 && !empty($this->code)) {
            $reservatonModel = $mvcFactory->createModel('Reservation', 'Administrator', ['ignore_request' => true]);
            $assetModel      = $mvcFactory->createModel('ReservationAsset', 'Administrator', ['ignore_request' => true]
            );
            $reservation     = $reservatonModel->getItem($this->id);
            $this->asset     = null;
            if ($reservation->code == $this->code) {
                $this->reservation  = $reservation;
                $this->asset        = $assetModel->getItem($this->reservation->reservation_asset_id);
                $this->lengthOfStay = (int)Utility::calculateDateDiff(
                    $this->reservation->checkin,
                    $this->reservation->checkout
                );
            }
        }

        $this->layout = $this->app->input->getString('layout', '');

        if ($this->layout == 'final') {
            SolidresReservationFinalScreenDisplayEvent::dispatch(
                [
                    'code'    => $this->app->getUserState($this->context . '.code'),
                    'subject' => $this,
                ]
            );
        }

        $jsOptions = ['version' => Version::getHashVersion(), 'relative' => true];
        HTMLHelper::_('stylesheet', 'com_solidres/assets/main.min.css', $jsOptions);

        if ($errors = $this->get('Errors')) {
            throw new Exception(implode(PHP_EOL, $errors), 500);
        }

        parent::display($tpl);
    }
}
