<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Site\View\Wishlist;

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Event\Content\ContentPrepareEvent;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\Component\Solidres\Site\Helper\WishListHelper;
use Joomla\Plugin\System\Solidres\Extension\Solidres;
use Joomla\Registry\Registry;
use Solidres\Event\SolidresBaseEvent;
use Solidres\MVC\FactoryTrait;
use SRExperienceHelper;
use Solidres\Layout\LayoutHelper;

class HtmlView extends BaseHtmlView
{
    use FactoryTrait;

    protected $items;
    protected $scope;

    public function display($tpl = null)
    {
        $app      = Factory::getApplication();
        $scope    = strtolower($app->input->getString('scope', 'reservation_asset'));
        $wishList = WishListHelper::getInstance($scope);
        $view     = strtolower($app->input->getCmd('view'));

        if (!in_array($scope, ['reservation_asset', 'experience'])) {
            $scope = 'reservation_asset';
        }

        if (!$wishList->user->guest && $view != 'customer') {
            $customerGroups = ComponentHelper::getParams('com_solidres')->get('customer_user_groups', []);

            if (!empty(array_intersect($wishList->user->groups, $customerGroups))) {
                $wishList->app->redirect(
                    Route::_('index.php?option=com_solidres&view=customer&layout=wishlist&scope=' . $scope, false)
                );

                return;
            }
        }

        $items           = (array)$wishList->load();
        $itemList        = [];
        $feedbackEnabled = PluginHelper::isEnabled('solidres', 'feedback');

        if ($feedbackEnabled) {
            HTMLHelper::_('stylesheet', 'plg_solidres_feedback/assets/flags.css', ['relative' => true]);
            HTMLHelper::_('stylesheet', 'plg_solidres_feedback/assets/feedbacks.css', ['relative' => true]);
        }

        if ($scope == 'experience') {
            LayoutHelper::addIncludePath(JPATH_PLUGINS . '/solidres/experience/layouts');

            foreach ($items as $pk => $item) {
                $item = SRExperienceHelper::getItem((int)$pk);

                if ($feedbackEnabled) {
                    SolidresBaseEvent::getDispatcher()
                        ->dispatch(
                            'onSolidresFeedbackPrepare',
                            new ContentPrepareEvent(
                                'onSolidresFeedbackPrepare',
                                [
                                    'context' => 'com_solidres.experience',
                                    'subject' => $item,
                                    'params'  => new Registry($item->params),
                                    'page'    => 0,
                                ]
                            )
                        );
                }

                $itemList[] = $item;
            }
        } else {
            $modelAsset = $this->createModel('ReservationAsset');

            foreach ($items as $pk => $item) {
                $assetItem = $modelAsset->getItem((int)$pk);

                if ($feedbackEnabled) {
                    SolidresBaseEvent::getDispatcher()
                        ->dispatch(
                            'onSolidresFeedbackPrepare',
                            new ContentPrepareEvent(
                                'onSolidresFeedbackPrepare',
                                [
                                    'context' => 'com_solidres.asset',
                                    'subject' => $assetItem,
                                    'params'  => new Registry($assetItem->params),
                                    'page'    => 0,
                                ]
                            )
                        );
                }

                $itemList[] = $assetItem;
            }
        }

        $this->scope = $scope;
        $this->items = $itemList;

        parent::display($tpl);
    }
}
